///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//  Copyright  NetworkDLS 2002, All rights reserved
//
// THIS CODE AND INFORMATION IS PROVIDED "AS IS" WITHOUT WARRANTY OF 
// ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING BUT NOT LIMITED TO 
// THE IMPLIED WARRANTIES OF MERCHANTABILITY AND/OR FITNESS FOR A 
// PARTICULAR PURPOSE.
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

#ifndef _CSockSrvr_H
#define _CSockSrvr_H
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

//#define _DEBUG_SOCK_SERVER 1

#define INITSENDRECVSZ       1024 // The initial size of the client Send and Receive buffers.

#define PACKETHEADER         12345

#define TCPHANDLER_MS_WAIT   1
#define CLIENTTHREAD_MS_WAIT 1

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

// Used to pass class data to the client thread
typedef struct _CLIENTTHREADINFO{
    int Client;
}CLIENTTHREADINFO, *LPCLIENTTHREADINFO;

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

class CSockSrvr{
public:
    bool DoConnect(char *sRemoteAddr, int iRemotePort, int *ioutClient);
    bool GetClientData(int iClient, char *outsBuf, int *outiSize);
    bool GetNextClientData(int iClient, char *outsBuf, int *outiSize);
	bool Initialize(int iListenPort, int iMaxClients, bool bDefaultRawDataMode,
		bool bDefaultDropBadPackets, int iHardSendBufSz, int iHardRecvBufSz);
    bool IsClientDataPending(int iClient);
    bool IsClientDataWaiting(int iClient);
    bool SetNextSendData(int iClient, char *sData);
    bool SetNextSendDataEx(int iClient, char *sData, int iSize);
    bool SetSendData(int iClient, char *sData);
    bool SetSendDataEx(int iClient, char *sData, int iSize);
    bool Start(void);
    bool Stop(void);
    bool UnInitialize(void);
    bool WaitOnClientDataToBeRecvd(int iClient);
    bool WaitOnClientDataToBeSent(int iClient);
	int GetSendBufSz(int iAdd);
	int GetRecvBufSz(int iAdd);
	int GetCurrentClients(void);
    int GetMaxClients(void);
    int GetNextClientID(void);
    int SendData(int iClient, char *sData);
    int SendDataEx(int iClient, char *sData, int iSize);
    void DropBadPacketData(int iClient, bool bDropBad);
    void SetNextClientID(int iClientID);
    void SetRawStreamMode(int iClient, bool bRawMode);

	CRITICAL_SECTION CriticalSection1;

	class SubClass_Events{
	public:
		void OnBeginClientThread(CSockSrvr *lpCSockSrvr, int iClient);
		void OnEndClientThread(CSockSrvr *lpCSockSrvr, int iClient);
		bool OnAccept(CSockSrvr *lpCSockSrvr, int iClient);
		bool OnConnect(CSockSrvr *lpCSockSrvr, int iClient);
		bool OnAcceptConnect(CSockSrvr *lpCSockSrvr, int iClient);
		void OnDisconnect(CSockSrvr *lpCSockSrvr, int iClient);
		bool OnStart(CSockSrvr *lpCSockSrvr, int iListenPort);
		bool OnStop(CSockSrvr *lpCSockSrvr);
		bool OnSend(CSockSrvr *lpCSockSrvr, int iClient, char *sData, int iSize);
		bool OnRecv(CSockSrvr *lpCSockSrvr, int iClient, char *sData, int iSize);
	};
	SubClass_Events Events;

	//------------------------------------------------------------

private:
    bool DoConnectEx(char *sRemoteAddr, int iRemotePort, int *ioutClient);
    bool Close_ListenSocket(void);
    bool DisconnectClient(int iClient);
    bool DoAccept(void);
    bool DoRecv(int iClient);
    bool DoSend(int iClient);
    bool OnAcceptConnectClient(int iClient);
    void OnDisconnectClient(int iClient);
    bool Open_ListenSocket(int iListenPort);
	bool ResizeSendBuffer(int iClient, int iSize);
	bool ResizeRecvBuffer(int iClient, int iSize);
    bool Start_ClientThread(int iClient);
    bool Start_WindowsSocket(void);
    bool Stop_WindowsSocket(void);
    bool WaitOnClientThreadToExit(int iClient);
    int BreakClassPacket(int iClient, char *outBuf, int *iOutBufSz);
    int MakeClassPacket(char *outBuffer, const char *inBuffer, int inLength);
	int GetPartialPacketDifference(int iClient);
	int GetFreeSocketSlot(void); // Search for free client "Slot"

public:
    //------------------------------------------------------------------------
    //Client specific items (Begin)
    //------------------------------------------------------------------------
    bool *bcConnected;            // Remote client's connection flag.
    bool *bcDisconnect;           // Remote client's disconnect flag.
    bool *bcDropBadPackets;       // Drop bad client packets? (True=Drop Packet, False=Disconnect Client)
    bool *bcRawDataMode;          // Is this client using Raw or Packet data mode (True=Raw, False=Packet)
	bool *bcWasConnect;           // True is the client was connected, false if the client was accepted.

	char **scRecvBuf;             // Clients receive buffer.
    char **scSendBuf;             // Clients send buffer.

	int *icClientID;              // Remote client's ID (For client identification).
	int *icMaxSendBufSz;          // The amount of memory allocated for scSendBuf.
	int *icMaxRecvBufSz;          // The amount of memory allocated for scRecvBuf.
	int *icRecvBufSz;             // The size of the content in the clients scRecvBuf.
    int *icRecvOffset;            // Data offset (Used for packet data).
    int *icSendBufSz;             // The size of the content in the clients scSendBuf.

	SOCKET *sckcSocket;           // Remote client's socket.

	bool cbActive;                // Is the server started?
    bool bcDefaultRawDataMode;    // The default Raw Data Mode setting for connecting clients.
    bool bcDefaultDropBadPackets; // The default Drop Bad Packets setting for connecting clients.

	int icListenPort;

	DWORD *dwcClient_Thread_ID;     //The array of client thread ID's.
    HANDLE *hcClient_Thread_Handle; //The array of client thread Handles's.

private:
    friend DWORD WINAPI Client_Thread_Function(LPVOID pvThread); //The client thread function.

    CLIENTTHREADINFO CTI;
    //------------------------------------------------------------------------
    //Client specific items (End)
    //------------------------------------------------------------------------

    int icCurrentClients;    // The amount of clients connected to the server.
    int icMaxClients;        // Max clients allowed to connect.
    int icNextClientID;      // The next assigned Client ID.
	int icHardSendBufSz;     // The MAX size of the class send buffer. MAX Packet send Size.
	int icHardRecvBufSz;     // The MAX size of the class receive buffer. MAX Packet receive Size.
	char *scSendBuffer;      // The class send buffer.
	char *scRecvBuffer;      // The class receive buffer.

    SOCKET sckcListenSocket; // Listen socket of local server

    fd_set ExceptFDS; // FDS Except
    fd_set ReadFDS;   // FDS Read
    fd_set WriteFDS;  // FDS Write

    struct timeval TimeOut;  // The TimeOut structure.

    bool IsListeningServer;  // Is this class acting as a listening server?

    //------------------------------------------------------------------------
    //The TCPHandler routine threading items (Begin)
    //------------------------------------------------------------------------
    friend DWORD WINAPI TCPHandler_Thread_Function(LPVOID pvThread);

    bool Start_TCPHandler(void);
    bool Stop_TCPHandler(void);

    bool bcShutdownTCPHandler;
    bool bcTCPHandlerActive;

    DWORD dwcTCPHandler_Thread_ID;
    HANDLE hcTCPHandler_Thread_Handle;
    //------------------------------------------------------------------------
    //The TCPHandler routine threading items (End)
    //------------------------------------------------------------------------
};

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

void FatalError(char *sFile, int iLine, char *sErrorMsg);

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//NON-STANDARD DEFINITIONS (BEGIN)

extern CSockSrvr gServer;

//NON-STANDARD DEFINITIONS (END)
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
#endif

